unit MemoF;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TFormMemo = class(TForm)
    Memo1: TMemo;
    BitBtn1: TBitBtn;
    Panel1: TPanel;
    BitBtn2: TBitBtn;
    procedure FormResize(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormMemo: TFormMemo;

implementation

uses OutForm;

{$R *.DFM}

procedure TFormMemo.FormResize(Sender: TObject);
begin
  // approximately in the middle
  BitBtn1.Left := Panel1.Width div 2 - BitBtn1.Width - 5;
  BitBtn2.Left := Panel1.Width div 2 + 5;
end;

procedure TFormMemo.BitBtn2Click(Sender: TObject);
var
  StrBin, StrTxt: TMemoryStream;
  TempForm1: TOutputForm;
begin
  StrBin := TMemoryStream.Create;
  StrTxt := TMemoryStream.Create;
  // copy the text of the memo
  Memo1.Lines.SaveToStream (StrTxt);
  // go back to the beginning
  StrTxt.Seek (0, soFromBeginning);
  try
    // convert to binary
    ObjectTextToResource (StrTxt, StrBin);
    // go back to the beginning
    StrBin.Seek (0, soFromBeginning);
    // loading code...
    TempForm1 := TOutputForm.Create (Application);
    StrBin.ReadComponentRes (TempForm1);
    OutputForm.Free;
    OutputForm := TempForm1;
    OutputForm.Show;
    // close the memo form
    ModalResult := mrOk;
  except
    on E: Exception do
    begin
      E.Message :=
        'Error converting form'#13#13 +
        '(' + E.MEssage + ')';
      Application.ShowException (E);
    end;
  end;
end;

end.
