unit TitleF;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    CheckBox1: TCheckBox;
    Edit1: TEdit;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    RadioButton2: TRadioButton;
    RadioButton1: TRadioButton;
    procedure AnyClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  TypInfo;

{$R *.DFM}

procedure TForm1.AnyClick(Sender: TObject);
var
  PropInfo: PPropInfo;
  Capt: string;
//  pcCapt: array [0..100] of Char;
begin
  // we'd like to write:
  // Sender.Caption := Sender.Caption + '*';

{  // Solution 1:

  // get the current value
  (Sender as TControl).GetTextBuf (
    pcCapt, sizeof (pcCapt));
  // add a *
  StrCat (pcCapt, '*');
  // set the new value
  (Sender as TControl).SetTextBuf (pcCapt);}

  // Solution 2:

  // get property RTTI
  PropInfo := GetPropInfo (Sender.ClassInfo, 'Caption');
  // try again
  if PropInfo = nil then
    PropInfo := GetPropInfo (Sender.ClassInfo, 'Text');

  // if found, apply the new value
  if PropInfo <> nil then
  begin
    Capt := GetStrProp (Sender, PropInfo);
    Capt := Capt + '*';
    SetStrProp (Sender, PropInfo, Capt);
  end;
end;

end.
