{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{       Copyright (c) 1995,97 Borland International     }
{                                                       }
{*******************************************************}
{                                                       }
{       With comments added by Marco Cant for          }
{       the book "Delphi Developer's Handbook"          }
{                                                       }
{*******************************************************}

unit CTypInfo;

interface

uses SysUtils;

type

{ Datatype-related enumerations and sets used by the unit... }

  TTypeKind = (tkUnknown, tkInteger, tkChar, tkEnumeration, tkFloat,
    tkString, tkSet, tkClass, tkMethod, tkWChar, tkLString,
    tkVariant, tkArray, tkRecord, tkInterface);
  TTypeKinds = set of TTypeKind;

  TOrdType = (otSByte, otUByte, otSWord, otUWord, otSLong);

  TFloatType = (ftSingle, ftDouble, ftExtended, ftComp, ftCurr);

  TMethodKind = (mkProcedure, mkFunction, mkSafeProcedure, mkSafeFunction);
  TParamFlags = set of (pfVar, pfConst, pfArray, pfAddress, pfReference, pfOut);
  TIntfFlags = set of (ifHasGuid, ifDispInterface, ifDispatch);


{-----------------------------}
{    TTypeInfo - PTypeInfo    }
{-----------------------------}

  {PPTypeInfo is the type returned by the TObject.ClassInfo method
  and by: function TypeInfo(TypeIdent): Pointer;

  To access the TypeData member you can simply use the
  GetTypeData function (which simply increases the pointer)}

  PPTypeInfo = ^PTypeInfo; // a pointer to a pointer
  PTypeInfo = ^TTypeInfo; // a pointer to TTypeInfo
  TTypeInfo = record
    Kind: TTypeKind;
    Name: ShortString;
   {TypeData: TTypeData}
  end;


{-----------------------------}
{    TTypeData - PTypeData    }
{-----------------------------}

  {PTypeData is the pointer returned by the GetTypeData
  function. This basically returns a pointer the TypeData
  area of the TTypeINfo record.

  You can use this structure directly to get TTypeKind-dependent
  information. Notice that this variant record is multi-level!
  This is not the original version, but a "more readable one"}

  PTypeData = ^TTypeData; // a pointer to TTypeData
  TTypeData = packed record
    case TTypeKind of
      tkUnknown: ();  // no information
      tkLString: ();  // no information
      tkLWString: ();  // no information
      tkVariant: ();  // no information
      tkInteger: (
        OrdType: TOrdType;
        // otSByte, otUByte, otSWord, otUWord, otSLong;
        MinValue: Longint;
        MaxValue: Longint);
      tkChar, tkWChar: (
        OrdType: TOrdType;
        // otSByte, otUByte, otSWord, otUWord, otSLong;
        MinValue: Longint;
        MaxValue: Longint);
      tkEnumeration: (
        OrdType: TOrdType;
        // otSByte, otUByte, otSWord, otUWord, otSLong;
        MinValue: Longint;
        MaxValue: Longint;
        BaseType: PPTypeInfo;
        // the original type definition
        NameList: ShortString);
        // the enumeration names (see GetEnumName)
      tkSet: (
        OrdType: TOrdType;
        // otSByte, otUByte, otSWord, otUWord, otSLong;
        CompType: PPTypeInfo);
        // the enumerated type the set is built from
      tkFloat: (
        FloatType: TFloatType);
        // ftSingle, ftDouble, ftExtended, ftComp, ftCurr
      tkString: (
        MaxLength: Byte);
      tkClass: (
        ClassType: TClass;
        // the class reference
        ParentInfo: PPTypeInfo;
        // the parent type information
        PropCount: SmallInt;
        // the number of properties
        UnitName: ShortString
        // the unit defining the class type
       {PropData: TPropData});
       // the properties data: to access this information
       // call procedure GetPropInfos or function GetPropList
      tkMethod: (
        MethodKind: TMethodKind;
        // mkProcedure, mkFunction, mkSafeProcedure, mkSafeFunction
        ParamCount: Byte;
        // the number of parameters
        ParamList: array[0..1023] of Char
        // the parameters list, better described as:
       {ParamList: array[1..ParamCount] of
          record
            Flags: TParamFlags;
            // TParamFlags = set of (pfVar, pfConst, pfArray,
            //   pfAddress, pfReference, pfOut);
            ParamName: ShortString;
            TypeName: ShortString;
          end;
        ResultType: ShortString});
        // the return type
      tkInterface: (
        IntfParent : PPTypeInfo;
        // ancestor type
        IntfFlags : TIntfFlags;
        // set of (ifHasGuid, ifDispInterface, ifDispatch)
        GUID : TGUID;
        // the GUID of the interface
        IntfUnit : ShortString;
        // the unit defining the interface type
       {PropData: TPropData});
       // the properties data
  end;

  {The TPropData structure, used in the TTypeData
  structure above is seldom used. Gives an idea of the
  contents of the TTypeData for classes}

  TPropData = packed record
    PropCount: Word;
    PropList: record end;
   {PropList: array[1..PropCount] of TPropInfo}
  end;

{-----------------------------}
{    TPropInfo - PPropInfo    }
{-----------------------------}

  {PPropInfo is the pointer returned by the
  GetPropInfo function. The GetPropInfos procedure,
  instead, fills a list of such pointer (see later on).

  This structure reveals a lot of information
  about properties including a pointer to the
  type information, the pointers to the procedures
  used to operate on the property, and the name}

  PPropInfo = ^TPropInfo;
  TPropInfo = packed record
    PropType: PTypeInfo; // property type RTTI
    GetProc: Pointer; // read method
    SetProc: Pointer; // write method
    StoredProc: Pointer; // store method
    Index: Integer; // property index
    Default: Longint; // default value (odd type)
    NameIndex: SmallInt; // index of the name
    Name: ShortString; // name
  end;

  // seems to be the parameter of an enumerated function
  // but it is not used anywhere in the VCL source...
  TPropInfoProc = procedure(PropInfo: PPropInfo) of object;

{-----------------------------}
{    TPropList - PPropList    }
{-----------------------------}

  {TPropList is a list of pointers to properties RTTI
  information. PPropList is a pointer to the list of pointers}

  PPropList = ^TPropList;
  TPropList = array[0..16379] of PPropInfo;

const
  // predefined filters for the GetPropList function
  tkAny = [Low(TTypeKind)..High(TTypeKind)];
  tkMethods = [tkMethod];
  tkProperties = tkAny - tkMethods - [tkUnknown];


{-----------------------------}
{    Generic RTTI Routines    }
{-----------------------------}

{GetTypeData returns the pointer to the type data from the
TTypeInfo structure the parameters points to. This code is
required to skip the variable-length string}
function GetTypeData(TypeInfo: PTypeInfo): PTypeData;

{funtions accessing to the NameList field of the
TTypeData structure for enumerated data types. Basically
extracts substrings from a packed list of variable
length strings}
function GetEnumName(TypeInfo: PTypeInfo;
  Value: Integer): string;
function GetEnumValue(TypeInfo: PTypeInfo;
  const Name: string): Integer;

{GetPropInfo extracts the PProfInfo pointer for a specific
property passed by name. The code looks into the PropData field
of the TTypeData structure for classes.}
function GetPropInfo(TypeInfo: PTypeInfo;
  const PropName: string): PPropInfo;

{These functions fill the PropList parameter with a list of
pointers to properties RTTI information. GetPropInfos returns
all of the properties, while GetPropList allows you to specify
a filter on the kind of properties you are interested in}
procedure GetPropInfos(TypeInfo: PTypeInfo; PropList: PPropList);
function GetPropList(TypeInfo: PTypeInfo; TypeKinds: TTypeKinds;
  PropList: PPropList): Integer;

// helper ruotine returning whether the property is stored
function IsStoredProp(Instance: TObject; PropInfo: PPropInfo): Boolean;

{--------------------------------}
{    Property Access Routines    }
{--------------------------------}

{The following routines are used to read or write a property
of a given "kind" of data type. Each routine has an Instance
parameter, the pointer to the object, and a PProfInfo parameter
related to the property you want to access to. Then the SetXxx
procedures require the new value, while the GetXxx functions
return the current one}

function GetOrdProp(Instance: TObject; PropInfo: PPropInfo): Longint;
procedure SetOrdProp(Instance: TObject; PropInfo: PPropInfo;
  Value: Longint);

function GetStrProp(Instance: TObject; PropInfo: PPropInfo): string;
procedure SetStrProp(Instance: TObject; PropInfo: PPropInfo;
  const Value: string);

function GetFloatProp(Instance: TObject; PropInfo: PPropInfo): Extended;
procedure SetFloatProp(Instance: TObject; PropInfo: PPropInfo;
  Value: Extended);

function GetVariantProp(Instance: TObject; PropInfo: PPropInfo): Variant;
procedure SetVariantProp(Instance: TObject; PropInfo: PPropInfo;
  const Value: Variant);

function GetMethodProp(Instance: TObject; PropInfo: PPropInfo): TMethod;
procedure SetMethodProp(Instance: TObject; PropInfo: PPropInfo;
  const Value: TMethod);

implementation

end.
