unit EmpD;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, EmpSrvr_TLB, StdVcl, DBXpress, DB, SqlExpr, FMTBcd, Provider;

type
  TEmployeeDm = class(TRemoteDataModule, IEmployeeDm)
    EmpConn: TSQLConnection;
    EmpDs: TSQLDataSet;
    EmpProv: TDataSetProvider;
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    function Get_CustomerRdm: ICustomerDm; safecall;
  public
    { Public declarations }
  end;

implementation

uses CustD;

{$R *.DFM}

class procedure TEmployeeDm.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

function TEmployeeDm.Get_CustomerRdm: ICustomerDm;
begin
  Result := CustRDMFactory.CreateCOMObject(nil) as ICustomerDm;
  Result.EmployeeRdm := Self;
end;

initialization
  TComponentFactory.Create(ComServer, TEmployeeDm,
    Class_EmployeeDm, ciMultiInstance, tmApartment);
end.
