unit CustD;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, EmpSrvr_TLB, StdVcl, FMTBcd, Provider, DB, SqlExpr;

type
  TCustomerDm = class(TRemoteDataModule, ICustomerDm)
    CustDs: TSQLDataSet;
    CustProv: TDataSetProvider;
  private
    { Private declarations }
    FEmployeeRdm:      IEmployeeDm;
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    function Get_EmployeeRdm: IEmployeeDm; safecall;
    procedure Set_EmployeeRdm(const Value: IEmployeeDm); safecall;
  public
    { Public declarations }
  end;

var
  CustRdmFactory:  TComponentFactory;

implementation

uses EmpD;

{$R *.DFM}

class procedure TCustomerDm.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

function TCustomerDm.Get_EmployeeRdm: IEmployeeDm;
begin
  Result := FEmployeeRdm;
end;

procedure TCustomerDm.Set_EmployeeRdm(const Value: IEmployeeDm);
begin
  FEmployeeRdm := Value;
end;

initialization
  CustRdmFactory := TComponentFactory.Create(ComServer, TCustomerDm,
    Class_CustomerDm, ciInternal, tmApartment);
end.
