unit MainD;

interface

uses
  SysUtils, Classes, DBClient, DB, MConnect;

type
  TMainDm = class(TDataModule)
    EmpDcom: TDCOMConnection;
    EmpBrkr: TConnectionBroker;
    EmpCds: TClientDataSet;
    EmpSrc: TDataSource;
    CustShrd: TSharedConnection;
    CustBrkr: TConnectionBroker;
    CustCds: TClientDataSet;
    CustSrc: TDataSource;
    procedure DataModuleCreate(Sender: TObject);
    procedure EmpCdsReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure CustCdsReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure EmpCdsAfterPost(DataSet: TDataSet);
    procedure CustCdsAfterPost(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainDm: TMainDm;

implementation

uses RecErrF;

{$R *.dfm}

procedure TMainDm.DataModuleCreate(Sender: TObject);
begin
  EmpCds.Open;
  CustCds.Open;
end;

procedure TMainDm.EmpCdsReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  Action := HandleReconcileError(DataSet,  UpdateKind, E);
end;

procedure TMainDm.CustCdsReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  Action := HandleReconcileError(DataSet,  UpdateKind, E);
end;

procedure TMainDm.EmpCdsAfterPost(DataSet: TDataSet);
begin
  EmpCds.ApplyUpdates(0);
end;

procedure TMainDm.CustCdsAfterPost(DataSet: TDataSet);
begin
  CustCds.ApplyUpdates(0);
end;

end.
