unit LineUnit;
{     ,    ""  -   ,
       ,     . 
          . ,  
      -   ,     
     .      :
     1) ,        ,  
         .
     2)         .
     3) ,    .
     4)    .
     5)    "".
         .     
       (,  ),   Win API.
           ,  , 
     . ,  ,     
     .      .

    :   (grigorievab@mail.ru), , 1999
       Delphi (http://delphi.vitpc.com)                     }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,Math;

type
  TLinesForm = class(TForm)
    RGroupLine: TRadioGroup;
    procedure FormMouseDown(Sender:TObject;Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
    procedure FormMouseMove(Sender:TObject;Shift:TShiftState;X,Y:Integer);
    procedure FormMouseUp(Sender:TObject;Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
    procedure FormCreate(Sender: TObject);
   private
    LineDrawing:Boolean;  //    True,     
                          //   .
    BegX,BegY:Integer;    //      "" .
    OldX,OldY:Integer;    //      ""  
                          //       .
    procedure Line(X1,Y1,X2,Y2:Integer);
  end;

var
  LinesForm: TLinesForm;

implementation

{$R *.DFM}

var Counter:Integer;    //     
    DX1,DY1,DX2,DY2:Integer;   //       ""

{    LineDrawXXX -     (callback-) 
    LineDDE.   ,     ,   
    "   Windows API",     . Windows 
    ,   ,   ,       
    ,     .   ,   
       - ,   -      
     .   }

procedure LineDrawRGB(X,Y:Integer;Canvas:TCanvas);stdcall;
 //  ,        ,  
 //   .
 begin
  case Counter mod 15 of
   0..4:Canvas.Pixels[X,Y]:=clRed;
   5..9:Canvas.Pixels[X,Y]:=clLime;
   10..14:Canvas.Pixels[X,Y]:=clBlue
  end;
  Inc(Counter)
 end;

procedure LineDrawRandom(X,Y:Integer;Canvas:TCanvas);stdcall;
 //           .
 begin
  Canvas.Pixels[X,Y]:=RGB(Random(256),Random(256),Random(256))
 end;

procedure LineDrawCross(X,Y:Integer;Canvas:TCanvas);stdcall;
 //   ,    .
 begin
  if Counter mod 7=0 then
   with Canvas do
    begin
     MoveTo(X-2,Y);
     LineTo(X+3,Y);
     MoveTo(X,Y-2);
     LineTo(X,Y+3)
     {   ,       Windows,  ,
              ,      
          ,    .    . -  Microsoft
         ,   ,       .
          ,       .  ,  
             ,     ,  
          .    ,      
         ,    .      ? 
          " "  ?

               ,    ,
                   .

         ,  Windows     .   
         Rectangle(10, 10, 100, 100),        
         ? ,   (99, 99). ,   Borland (, Inprise),
             ,      .    }
    end;
  Inc(Counter)
 end;

procedure LineDrawThick(X,Y:Integer;Canvas:TCanvas);stdcall;
 //      .
 begin
  case Counter mod 28 of
   0..6:Canvas.Ellipse(X-2,Y-2,X+3,Y+3);
   7..13,21..27:Canvas.Ellipse(X-1,Y-1,X+2,Y+2);
   14..20:Canvas.Pixels[X,Y]:=clRed
  end;
  {   ,  ,    ,    
        .   }
  Inc(Counter)
 end;

procedure LineDrawFir(X,Y:Integer;Canvas:TCanvas);stdcall;
 //      "".
 begin
  with Canvas do
   case Counter mod 10 of
    0:begin
       MoveTo(X,Y);
       LineTo(X+DX1,Y+DY1)
      end;
    5:begin
       MoveTo(X,Y);
       LineTo(X+DX2,Y+DY2)
      end
   end;
  Inc(Counter)
 end;

procedure TLinesForm.Line;
 var Angle:Extended;
  //      ,    , 
  //       LineDDA   callback-.
  //    -    Microsoft Win API  
  //    ArcDDA, EllipseDDA  . .,     
  //     .
  begin
   case RGroupLine.ItemIndex of
    0:begin
       Counter:=0;
       LineDDA(X1,Y1,X2,Y2,@LineDrawRGB,Integer(Canvas))
      end;
    1:LineDDA(X1,Y1,X2,Y2,@LineDrawRandom,Integer(Canvas));
    2:begin
       Counter:=0;
       LineDDA(X1,Y1,X2,Y2,@LineDrawCross,Integer(Canvas))
      end;
    3:begin
       Counter:=0;
       LineDDA(X1,Y1,X2,Y2,@LineDrawThick,Integer(Canvas))
      end;
    4:begin
       Counter:=0;
       Angle:=ArcTan2(Y2-Y1,X2-X1);
       DX1:=Round(8*Cos(Angle+Pi/6));
       DY1:=Round(8*Sin(Angle+Pi/6));
       DX2:=Round(8*Cos(Angle-Pi/6));
       DY2:=Round(8*Sin(Angle-Pi/6));
       LineDDA(X1,Y1,X2,Y2,@LineDrawFir,Integer(Canvas))
      end
   end
  end;

procedure TLinesForm.FormMouseDown(Sender:TObject;Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
 begin
  if Button=mbLeft then
   begin
    MouseCapture:=True;
    OldX:=X;
    OldY:=Y;
    BegX:=X;
    BegY:=Y;
    LineDrawing:=True
    {           "" .
                .   }
   end
 end;

procedure TLinesForm.FormMouseMove(Sender:TObject;Shift:TShiftState;X,Y:Integer);
 begin
  if LineDrawing and ((X<>OldX) or (Y<>OldY)) then
   with Canvas do
    begin
     SetROP2(Handle,R2_Not);
     {     ,  ,    , ,
             ,  ,   ,   
            .       
           R2_CopyPen,   .   
          ,           ,
              ,      .  ,
                  . ,
          R2_Not    .   ,  
            X   not not X = X. ,   
            ,        ,  
         - ,     .  ,
               "not"  X,     
           .         
          .        
               . ,   "" 
          ,  ,    ,    
             :     ,   -
          . ,     ""   ,
             .  ,  ,   
         ,          (  -
          ),        (bitmap),  
                .   ,
            ,    . ,  
          Win32 Developer's Refernce ,   SetROP2  
            .  ,     
               SetPixel,   
          TCanvas.Pixels.    }
     Line(BegX,BegY,OldX,OldY);    //      .
     Line(BegX,BegY,X,Y);          //     .
     OldX:=X;
     OldY:=Y
    end
 end;

procedure TLinesForm.FormMouseUp(Sender:TObject;Button:TMouseButton;Shift:TShiftState;X,Y:Integer);
 begin
  if (Button=mbLeft) and LineDrawing then
   begin
    case RGroupLine.ItemIndex of
     2:Canvas.Pen.Color:=clBlue;
     3:begin
        Canvas.Brush.Color:=clRed;
        Canvas.Pen.Color:=clRed
       end;
     4:Canvas.Pen.Color:=clGreen
    end;
    Line(BegX,BegY,X,Y);
    LineDrawing:=False;
    MouseCapture:=False
    {            , 
          ""    .  , 
                 "" .
              ,       
             .    }
   end
 end;

procedure TLinesForm.FormCreate(Sender: TObject);
 begin
  LineDrawing:=False;
  Randomize
 end;

end.
