unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    CB: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CBChange(Sender: TObject);
    procedure StringGrid1SelectCell(Sender: TObject; Col, Row: Integer;
      var CanSelect: Boolean);
    procedure CBExit(Sender: TObject);
    procedure StringGrid1Click(Sender: TObject);
    procedure CBDropDown(Sender: TObject);
  private
    { Private declarations }
	CurrentCell: TGridCoord;
    CBShown: Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  List: TStringList;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
	List := TStringList.Create;
    List.Add('Part 1');
    List.Add('Part 2');
    List.Add('Part 3');
    List.Add('Part 4');
    CB.Items.Assign(List);
    CB.Items.Insert(0,' ');
    CBShown := True;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
	List.Free;
end;

procedure TForm1.CBChange(Sender: TObject);
begin
	if CB.Visible then begin
    	CB.Visible := False;
        StringGrid1.Cells[CurrentCell.X,CurrentCell.Y] := CB.Text;
    end;
end;

procedure TForm1.StringGrid1SelectCell(Sender: TObject; Col, Row: Integer;
  var CanSelect: Boolean);
begin
	if CBShown then begin
		CB.ItemIndex :=
    		CB.Items.IndexOf(StringGrid1.Cells[Col,Row]);
		CurrentCell.X := Col;
		CurrentCell.Y := Row;
		CBShown := False;
    end;
end;

procedure TForm1.CBExit(Sender: TObject);
begin
	CB.Visible := False;
end;

procedure TForm1.StringGrid1Click(Sender: TObject);
var i: integer;
	Rct: TRect;
begin
	if not CBShown then begin
		StringGrid1.Col := CurrentCell.X;
		StringGrid1.Row := CurrentCell.Y;
    	Rct := StringGrid1.CellRect(CurrentCell.X,CurrentCell.Y);
    	CB.Left := StringGrid1.Left+Rct.Left+2;
    	CB.Top := StringGrid1.Top+Rct.Top+2;
        CB.Width := StringGrid1.ColWidths[StringGrid1.Col];
    	CB.Visible := True;
    	CB.SetFocus;
    	CBShown := True;
    end;
end;

procedure TForm1.CBDropDown(Sender: TObject);
begin
	CB.Width := CB.Width*2;
end;

end.
