unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RC5, Grids;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    StringGrid1: TStringGrid;
    StringGrid2: TStringGrid;
    StringGrid3: TStringGrid;
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Button3: TButton;
    Button4: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Block1,
  Block2,
  Block3 : TRC5Block;

implementation

{$R *.dfm}

procedure ShowResults;
var
  i : Byte;
begin
 for i := 1 to 2 do
   begin
     Form1.StringGrid1.Cells[0,i-1] := IntToHex(Block1[i], 4);
     Form1.StringGrid2.Cells[0,i-1] := IntToHex(Block2[i], 4);
     Form1.StringGrid3.Cells[0,i-1] := IntToHex(Block3[i], 4);
   end;
end;

procedure FillBlock;
var
  i : Byte;
begin
 for i := 1 to 2 do
   begin
     try
       Block1[i] := StrToInt('$0'+Form1.StringGrid1.Cells[0,i-1]);
       Block2[i] := StrToInt('$0'+Form1.StringGrid2.Cells[0,i-1]);
     except
       ShowMessage('-   ');
       Exit;
     end;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Randomize;
end;

procedure TForm1.FormShow(Sender: TObject);
var
  i : Byte;
begin
 for i := 1 to 2 do
   Block1[i] := Trunc(Random(High(LongWord)));
 ShowResults;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  i : Byte;
begin
 FillBlock;

 Initialize(Edit1.Text);
 CalculateSubKeys;
 
 for i := 1 to 2 do
   Block2[i] := Block1[i];
 EncipherBlock(Block2);
 ShowResults;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  i : Byte;
begin
 FillBlock;

 Initialize(Edit1.Text);
 CalculateSubKeys;

 for i := 1 to 2 do
   Block3[i] := Block2[i];
 DecipherBlock(Block3);
 ShowResults;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  Str1, Str2 : TFileStream;
begin
 Str1 := TFileStream.Create(Edit2.Text, fmOpenRead);
 Str2 := TFileStream.Create(Edit3.Text, fmCreate);

 EncryptCopy(Str2, Str1, Str1.Size, Edit4.Text);

 Str1.Free;
 Str2.Free;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  Str1, Str2 : TFileStream;
begin
 Str1 := TFileStream.Create(Edit2.Text, fmOpenRead);
 Str2 := TFileStream.Create(Edit3.Text, fmCreate);

 DecryptCopy(Str2, Str1, Str1.Size, Edit4.Text);

 Str1.Free;
 Str2.Free;
end;

end.
